﻿$(document).ready(function () {
    messagesTranslationEditor.$context = $("#translate");
    messagesTranslationEditor.initialize();
    messagesTranslationEditor.bindGeneralEvents();
    messagesTranslationEditor.bindMessagesEvents();
});

var messagesTranslationEditor = {
    $context: null,
    questionnaireId: 0,
    initialize: function () {
    },
    bindGeneralEvents: function () {
        IsAutoTranslateLicenseActive();

        $(".v-translateLanguage, .v-referenceLanguage", messagesTranslationEditor.$context).each(function () {
            $(this).data("prev", $(this).val());
        });

        $(".v-translateLanguage, .v-referenceLanguage", messagesTranslationEditor.$context).on("change", function () {
            var select = $(this);
            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (HasUnsavedChanges()) {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(messagesTranslationEditor.saveMessages())
                        .then(function () {
                            select.val(currentValue);
                            select.data("prev", currentValue);
                            messagesTranslationEditor.updateMessagesEditor();
                        });
                }, function () {
                    select.data("prev", currentValue);
                    messagesTranslationEditor.updateMessagesEditor();
                }, function () {
                    select.val(previousValue);
                });
            } else {
                select.data("prev", currentValue);
                messagesTranslationEditor.updateMessagesEditor();
            }
        });

        $(".v-saveQuestion").on("click", function () {
            $.when(messagesTranslationEditor.saveMessages(true))
                .then(function () { messagesTranslationEditor.updateMessagesEditor(); });
        });

        $(".v-autoTranslate").on("click", function () {
            if ($(this).hasClass('disabled')) {
                return;
            };

            a4.busyBoxEnabled = true;

            var translateLanguage = $(".v-translateLanguage").val();
            var referenceLanguage = $(".v-referenceLanguage").val();

            args = {
                referenceLanguageCode: referenceLanguage,
                translateLanguageCode: translateLanguage
            };
            
            modalDialog.showConfirmDialog(confirmTranslateMessageResources,
                function () {
                    a4.callServerMethod(a4.getSurveyAction("AutoTranslateMessages", "Translate", { surveyId: messagesTranslationEditor.questionnaireId }), args,
                        function (result) {
                            a4.showSuccessMessage(resources.SuccessTranslateMessage, 2000);
                            messagesTranslationEditor.updateMessagesEditor();
                            
                            if (typeof surveyMenu != 'undefined') {
                                surveyMenu.refresh();
                            }
                        }, 
                        function (result) {
                            if (result == undefined) {
                                return;
                            }

                            var parsedData = JSON.parse(result.responseText);

                            if (parsedData.IsApplicationException) {
                                modalDialog.showCustomDialog(
                                    parsedData.Message,
                                    resources.UnableToAutoTranslate,
                                    [{ Text: resources.CloseButton, LinkButton: true, Action: function() { modalDialog.close(); } }],
                                    null,
                                    null,
                                    true);
                                messagesTranslationEditor.updateMessagesEditor();
                            } else {
                                a4.showErrorMessage(parsedData.Message, 2000);
                            }
                        }, { dataType: "html" });
                }, 220, 500, false, {});
        });

        $(".v-cancel").on("click", function () {
            location.reload();
        });

        $(".v-print").on("click", function () {
            window.print();
        });
    },
    bindMessagesEvents: function () {
        $(".v-translationTextBox", messagesTranslationEditor.$context).on("change", function () {
            $(this).attr("data-changed", "true");
        });
    },
    updateMessagesEditor: function () {
        var $translationEdition = $("#messagesTranslationEditor .v-translatorContainer");
        var translateLanguage = $(".v-translateLanguage").val();
        var referenceLanguage = $(".v-referenceLanguage").val();

        args = {
            referenceLanguageCode: referenceLanguage,
            translateLanguageCode: translateLanguage
        }

        var action;

        if (messagesType == "SystemDefault") {
            action = a4.getAction("GetMessagesEditor", "Surveys", "Settings", {});
        }
        else {
            action = a4.getSurveyAction("GetMessagesEditor", "Translate", { surveyId: messagesTranslationEditor.questionnaireId });
        }

        a4.callServerMethod(action, args,
            function (result) {
                $translationEdition[0].innerHTML = result;
                messagesTranslationEditor.bindMessagesEvents();
                a4ImageSelector.bindElements($("#messagesTranslationEditor"));
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            },
            { blockElement: $("#translate"), blockElementTimeout: 0, dataType: "html" }
        );
    },
    saveMessages: function (reload) {
        var errorMessages = {};

        $(".v-errorMessage[data-changed='true']", messagesTranslationEditor.$context).map(function () { return TextObject(errorMessages, $(this)); });

        var action;
        var args = {
            toLanguage: $(".v-translateLanguage", messagesTranslationEditor.$context).val(),
            errorMessages: $.isEmptyObject(errorMessages) ? null : errorMessages
        };

        if (messagesType == "SystemDefault") {
            action = a4.getAction("UpdateDefaultErrorMessage", "Surveys", "Settings", {});
        }
        else {
            action = a4.getSurveyAction("UpdateMessages", "Translate", {});
            args["surveyId"] = messagesTranslationEditor.questionnaireId;
        }

        return a4.callServerMethod(action, args,
            function (result) {
                a4.showSuccessMessage(resources.SuccessMessage, 2000);

                if (typeof surveyMenu != 'undefined') {
                    surveyMenu.refresh();
                }
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            },
            { blockElement: $("#translate") }
        );
    }
}

function TextObject(texts, $textBox) {
    var key = $textBox.attr("data-key");
    var value = "";

    value = $textBox.val().trim();

    texts[key] = value;
}

function HasUnsavedChanges() {
    return $(".v-translationTextBox[data-changed='true']", messagesTranslationEditor.$context).length > 0;
}

function IsAutoTranslateLicenseActive() {
    a4.callServerMethod(a4.getSurveyAction("IsAutoTranslateLicenseActive", "Translate", null), null,
        function (result) {
            if (!result.active) {
                $(".v-autoTranslate").hide();
            }
        }
        , null, { dataType: "json" });
}
